#!/bin/sh
platform_os=`uname -s`

if [ "$platform_os" = "Linux" ];then
    # for rhel5 and SLES10 SP1 installs, lpfcdfc does not exist
    ioctl_driver="lpfcdfc"

    if [ -f /etc/redhat-release ]; then
       rhel_major_version=`cat /etc/redhat-release | awk '{ print $7 }' | awk -F. '{ print $1 }'`

       if [ "$rhel_major_version" -eq 4 ];then
           # is this rhel5 Tikanga release
           rhel5_check=`cat /etc/redhat-release | grep Tikanga`
           if [ -n "$rhel5_check" ];then
               ioctl_driver="lpfc"
           fi
       else
           ioctl_driver="lpfc"
       fi
    elif [ -f /etc/SuSE-release ]; then
       # Check for SLES10 SP1
       sles_major_version=`cat /etc/SuSE-release | grep VERSION | awk '{ print $3 }'`
       if [ "$sles_major_version" -eq 10 ]; then
           sles_minor_version=`cat /etc/SuSE-release | grep PATCHLEVEL | awk '{ print $3 }'`
           if [ -n "$sles_minor_version" ];then
               ioctl_driver="lpfc"
           fi
       fi
    fi
fi

# If HBAnyware running, then tell user to exit it before continuing
pid=`ps -eaf | grep HBAnyware.jar | grep -v grep | grep -v start | awk '{ print $2 }' | sort -n | head -1`
if [ ! -z "$pid" ];then
   echo " "
   echo "The HBAnyware utility is currently running.  Before starting"
   echo "Web Launch Services, you must first stop the HBAnyware utility"
   ehco "by performing the following steps:"
   echo " "
   echo "  - Exit the HBAnyware utility"
   echo "  - Stop all HBAnyware services by executing the shell"
   echo "    script '/usr/sbin/hbanyware/stop_hbanyware -n'"
   echo "  - Re-execute this script (rmiserver)"
   echo " "
   exit -1
fi

# Start HBAnyware RMI (Remote Method Invocation) Server; JRE is local for Linux installations

if [ "$platform_os" = "Linux" ];then

   # verify driver loaded
   lpfcdfc_loaded=`lsmod | awk '{ print $1 }' | grep "$ioctl_driver"`
   if [ -z "$lpfcdfc_loaded" ];then
      echo ""
      echo " $ioctl_driver driver module not loaded on machine."
      echo " The HBAnyware web launch service requires that the $ioctl_driver driver be loaded."
      echo " Please load $ioctl_driver driver (e.g. modprobe $ioctl_driver) and retry application."
      echo ""
      exit -1
   fi

   kernel_version=`uname -r 2>&1 | awk '{ print $1 }' | awk -F. '{ print $1$2 }'`
   platform_arch=`uname -m`
   if [ "$platform_arch" = "ppc64" ]; then
      if [ "$kernel_version" = "26" ]; then
         # Is this a 32-bit or 64-bit ppc installation
         jre_check=`file /usr/sbin/hbanyware/jre/bin/java | grep "ELF 32-bit"`
         if [ -n "$jre_check" ];then
            /usr/sbin/hbanyware/jre/bin/java -Djava.rmi.server.codebase="file:///usr/sbin/hbanyware/rmiserver.jar" -Djava.library.path=/usr/lib -Djava.rmi.server.hostname=%%RMI_SERVER_IP%% -jar /usr/sbin/hbanyware/rmiserver.jar > /dev/null 2>&1 &
         else
            /usr/sbin/hbanyware/jre/bin/java -Djava.rmi.server.codebase="file:///usr/sbin/hbanyware/rmiserver.jar" -Djava.library.path=/usr/lib64 -Djava.rmi.server.hostname=%%RMI_SERVER_IP%% -jar /usr/sbin/hbanyware/rmiserver.jar > /dev/null 2>&1 &
         fi
      else
         /usr/sbin/hbanyware/jre/bin/java -Djava.rmi.server.codebase="file:///usr/sbin/hbanyware/rmiserver.jar" -Djava.library.path=/usr/lib -Djava.rmi.server.hostname=%%RMI_SERVER_IP%% -jar /usr/sbin/hbanyware/rmiserver.jar > /dev/null 2>&1 &
      fi
   else
      if [ "$platform_arch" = "x86_64" ]; then
         /usr/sbin/hbanyware/jre/bin/java -Djava.rmi.server.codebase="file:///usr/sbin/hbanyware/rmiserver.jar" -Djava.library.path=/usr/lib64 -Djava.rmi.server.hostname=%%RMI_SERVER_IP%% -jar /usr/sbin/hbanyware/rmiserver.jar > /dev/null 2>&1 &
      else
         /usr/sbin/hbanyware/jre/bin/java -Djava.rmi.server.codebase="file:///usr/sbin/hbanyware/rmiserver.jar" -Djava.library.path=/usr/lib -Djava.rmi.server.hostname=%%RMI_SERVER_IP%% -jar /usr/sbin/hbanyware/rmiserver.jar > /dev/null 2>&1 &
      fi
   fi 
fi

if [ "$platform_os" = "SunOS" ];then
   java_version=`java -version 2>&1 | grep version | awk -F\" '{ print $2 }' | awk -F. '{ print $1$2 }'`
   if [ "$java_version" -lt 15 ]; then
      echo ""
      echo "Version 1.5 or later of the Java Runtime Environment must be installed."
      echo "The HBAnyware Web Launch server will not run under earlier versions of the JRE."
      echo "The JRE version can be checked by typing 'java -version' at the command line."
      echo ""
   else
      java -Djava.rmi.server.codebase="file:///usr/sbin/hbanyware/rmiserver.jar" -Djava.library.path=/usr/lib -Djava.rmi.server.hostname=%%RMI_SERVER_IP%% -jar /usr/sbin/hbanyware/rmiserver.jar > /dev/null 2>&1 &
   fi
fi
